<?php
require 'vendor/autoload.php';

use Google\Client as Google_Client;
use GuzzleHttp\Client as Guzzle_Client;

// Path to the service account JSON file
$serviceAccountPath = 'service_account.json';

// Initialize Google Client
$client = new Google_Client();
$client->setAuthConfig($serviceAccountPath);
$client->addScope('https://www.googleapis.com/auth/firebase.messaging');

// Get the OAuth 2.0 token
$token = $client->fetchAccessTokenWithAssertion()['access_token'];

// FCM endpoint
$fcmUrl = 'https://fcm.googleapis.com/v1/projects/placement-cell-6795a/messages:send';

// FCM message data
$message = [
    'message' => [
        'token' => 'eqVSe0ZyQW-432_XjL8D02:APA91bH0hRQO3OAeyLw1aDqYD1ecPD9de3CeSMXPG5oXjOX6nKC6UertJggjMXLu2il_VLCXVy24DlvqdIGWcL40AY5yhC-BeL4Zo77_bo2ogAogmJ2uZapFwFlj0PiomMaKVmUXC7_l',
        'notification' => array(
            'title' => 'Hello',
            'body' => 'World',
        ),
        'android' => array(
            'notification' => array(
                'channel_id' => 'Tbteck_Placement_Id'
            ),
            ),
        
    ]
];

// Initialize Guzzle Client
$guzzleClient = new Guzzle_Client();

try {
    $response = $guzzleClient->post($fcmUrl, [
        'headers' => [
            'Authorization' => 'Bearer ' . $token,
            'Content-Type' => 'application/json'
        ],
        'json' => $message
    ]);

    $responseBody = $response->getBody()->getContents();
    echo "Message sent successfully: " . $responseBody;
} catch (\Exception $e) {
    echo "Error sending message: " . $e->getMessage();
}

?>