function changeLanguage(language) {
  var element = document.getElementById("url");
  element.value = language;
  element.innerHTML = language;
}

function showDropdown() {
  document.getElementById("myDropdown").classList.toggle("show");
}

// Close the dropdown if the user clicks outside of it
window.onclick = function(event) {
  if (!event.target.matches(".dropbtn")) {
    var dropdowns = document.getElementsByClassName("dropdown-content");
    var i;
    for (i = 0; i < dropdowns.length; i++) {
      var openDropdown = dropdowns[i];
      if (openDropdown.classList.contains("show")) {
        openDropdown.classList.remove("show");
      }
    }
  }
};


//  **------tab link js**
$(document).on('click','.tab-link',function () {
	var tabID = $(this).attr('data-tab');

	$(this).addClass('active').siblings().removeClass('active');

	$('#tab-' + tabID).addClass('active').siblings().removeClass('active');
});

//  **------chart js**

var options = {
  series: [42, 47, 52, 58],
  chart: {
    height: 400,
    type: 'polarArea'
  },
  labels: ['Data A', 'Data B', 'Data C', 'Data D'],
  fill: {
    opacity: 1,
  },
  colors: [getLocalStorageItem('color-primary','#467ffb'), getLocalStorageItem('color-secondary','#74788d'), '#05b48a', '#eb565b', '#f9c353', '#29b0f2', '#e7eaef', '#283055'],
  stroke: {
    width: 1,
    colors: [getLocalStorageItem('color-primary','#467ffb'), getLocalStorageItem('color-secondary','#74788d'), '#05b48a', '#eb565b', '#f9c353', '#29b0f2', '#e7eaef', '#283055'],
  },
  yaxis: {
    show: false
  },
  legend: {
    position: 'bottom',
  },

  plotOptions: {
    polarArea: {
      rings: {
        strokeWidth: 0
      },
      colors: [getLocalStorageItem('color-primary','#467ffb'), getLocalStorageItem('color-secondary','#74788d'), '#05b48a', '#eb565b', '#f9c353', '#29b0f2', '#e7eaef', '#283055',],
      spokes: {
        strokeWidth: 0,
      },
    }
  },

  responsive: [{
    breakpoint: 1550,
    options: {
      chart: {
        height: 300,
      },
      legend: {
        position: 'bottom'
      }
    }
  },{
    breakpoint: 567,
    options: {
      chart: {
        height: 240,
      },
      legend: {
        position: 'bottom'
      }
    }
  }]

};

var chart = new ApexCharts(document.querySelector("#polar2"), options);
chart.render();