<?php
include('actions/session.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="Chat - Whatsapp Admin">
  <meta name="title" content="Chat - Whatsapp Admin">
  <meta name="author" content="Three Baboons Technologies">
  <link rel="icon" href="assets/images/logo/icon.png" type="image/x-icon">
  <link rel="shortcut icon" href="assets/images/logo/icon.png" type="image/x-icon">
  <title>Chat - Whatsapp Admin </title>

  <!--font-awesome-css-->
  <link rel="stylesheet" href="assets/vendor/fontawesome/css/all.css">

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600;700;800;900&display=swap"
    rel="stylesheet">

  <!-- tabler icons-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/tabler-icons/tabler-icons.css">

  <!--flag Icon css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/flag-icons-master/flag-icon.css">

  <!--animation-css-->
  <link rel="stylesheet" href="assets/vendor/animation/animate.min.css">

  <!-- simplebar css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/simplebar/simplebar.css">

  <!-- Bootstrap css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/bootstrap/bootstrap.min.css">

  <!-- App css-->
  <link rel="stylesheet" type="text/css" href="assets/css/style.css">

  <!-- Responsive css-->
  <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
  
  <link rel="stylesheet" type="text/css" href="assets/toasty_elements/toasty.css">
<style>
    .chat-container{
       overflow: auto;
       display: flex;
       height:250px !important;
       flex-direction: column-reverse;
    }
    .chat-contact{
        height:235px !important;
    }
    .chat_tab{
        cursor: pointer;
    }
    .chat_list{
        width:0%;
    }
    img{
        width:100%;
    }
    .maxw-80{
        max-width:80% !important;   
    }
    .image-container {
    display: inline-block;
    position: relative;
    }
    
    .img_checkbox {
        display: none; /* Hide the checkbox */
    }
    
    .image-label {
        display: block;
        width: 110px; /* Adjust as per your image size */
        height: 110px;
        border: 2px solid transparent;
        cursor: pointer;
        transition: border-color 0.3s ease, background-color 0.3s ease;
    }
    
    .image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .img_checkbox:checked + .image-label {
        border-color: blue; /* Color of the border when checked */
        background-color: rgba(0, 0, 255, 0.2); /* Fills background with color */
    }

</style>
</head>

<body>
  <div class="app-wrapper">
    <ul class="notifications"></ul>
    <div class="loader-wrapper">
 <div class="app-loader">
          <div class="loader-22">
          </div>
      </div>
    </div>

     <!-- Menu Navigation starts -->
     <?php include('include/navbar.php'); ?>
    <!-- Menu Navigation ends -->


    <div class="app-content">
      <div class="">

        <!-- Header Section starts -->
        <?php include('include/header.php'); ?>
        <!-- Header Section ends -->

        <!-- Body main section starts -->
        <main>
          <div class="container-fluid">
            <!-- Chat start -->
            <div class="row">
              <div class="col-sm-6">
                <h4 class="main-title">Chat</h4>
              </div>
              <div class="col-sm-6 mt-sm-2">
                <ul class="breadcrumb breadcrumb-start float-sm-end">
                  <li class="d-flex">
                    <i class="ti ti-server f-s-16"></i>
                    <a href="#" class="f-s-14"> <span class="d-none d-md-block">Apps</span></a>
                  </li>
                  <li class="d-flex active">
                    <a href="#" class="f-s-14">Chat</a>
                  </li>
                </ul>
              </div>
            </div>
            <!-- Chat end -->
            <div class="row chat-container-box position-relative">
              <div class="col-lg-4 col-xxl-3 box-col-5">
                <div class="chat-div">
                  <div class="card">
                    <div class="card-header">
                      <div class="d-flex align-items-center">
                        <span class="chatdp h-45 w-45 d-flex-center b-r-50 position-relative">
                          <img src="assets/images/avtar/08.png" alt="" class="img-fluid b-r-50">
                          <span
                            class="position-absolute top-0 end-0 p-1 bg-success border border-light rounded-circle"></span>
                        </span>
                        <div class="flex-grow-1 ps-2">
                          <div class="fs-6"> Three Baboons Technologies</div>
                          <div class="chat-text-ellipsis text-muted f-s-12">Admin</div>
                        </div>
                        <div>
                          <div class="btn-group dropdown-icon-none">
                            <a role="button" data-bs-placement="top" data-bs-toggle="dropdown" data-bs-auto-close="true"
                              aria-expanded="false">
                              <i class="ti ti-settings fs-5"></i>
                            </a>
                            <ul class="dropdown-menu" data-popper-placement="bottom-start">
                              <li><a class="dropdown-item" href="#"><i class="ti ti-brand-hipchat"></i> <span
                                    class="f-s-13">Chat Settings</span></a>
                              </li>
                              <li><a class="dropdown-item" href="#"><i class="ti ti-phone-call"></i> <span
                                    class="f-s-13">Contact Settings</span></a>
                              </li>
                              <li><a class="dropdown-item" href="#"><i class="ti ti-settings"></i> <span
                                    class="f-s-13">Settings</span></a>
                              </li>
                            </ul>
                          </div>
                        </div>
                        <div class="close-togglebtn">
                          <a class="ms-2 close-toggle" role="button"><i class="ti ti-align-justified fs-5"></i></a>
                        </div>
                      </div>
                    </div>
                    <div class="card-body">
                      <div class="chat-tab-wrapper">
                        <!--<ul class="tabs chat-tabs">-->
                        <!--  <li class="tab-link active" data-tab="1">Chat</li>-->
                          <!--<li class="tab-link" data-tab="2">Updates</li>-->
                          <!--<li class="tab-link" data-tab="3">Contact</li>-->
                        <!--</ul>-->
                        <input type="text" id="search_number" class="form-control" placeholder="Search user" onkeyup="search_numbers()">
                      </div>

                      <div class="content-wrapper">

                        <!-- tab 1 -->

                        <div id="tab-1" class="tabs-content active">
                          <div class="tab-wrapper">
                            <div class="mt-3">
                              
                            </div>
                          </div>
                        </div>
<!-- All Chat -->       
                          
                        <div class="tab-content" id="BasicContent">
                            <!-- Private Caht -->
                            <div class="tab-pane fade show active" id="private-tab-pane" role="tabpanel"
                              aria-labelledby="private-tab" tabindex="0">
                                <div class="chat-contact">
                                    <div id="chat_user"></div>
                                    <div id="search_user"></div>
                                    <input type="hidden" id="chat_phone">
                                </div>
                            </div>
                                
                            <div class="float-end">
                                <div class="btn-group dropup  dropdown-icon-none">
                                    <button class="btn btn-primary icon-btn b-r-22" type="button"  data-bs-toggle="modal"
                                data-bs-target="#exampleModalScrollable">
                                        <i class="ti ti-plus"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-8 col-xxl-9 box-col-7">
                <div class="card">
                    <div class="card-header">
                        <div class="chat-header d-flex align-items-center">
  <div class="d-lg-none">
    <a class="me-3 toggle-btn" role="button"><i class="ti ti-align-justified"></i></a>
  </div>
  <a href="#">
    <span class="profileimg h-50 w-50 d-flex-center b-r-50 position-relative">
      <img src="assets/images/logo/users.png" alt="" class="img-fluid b-r-50">
      <span
        class="position-absolute top-0 end-0 p-1 border border-light rounded-circle" id="dot"></span>
    </span>
  </a>
  <div class="flex-grow-1 ps-2 pe-2">
    <div class="fs-6"><span id="s_phone"></span></div>
    <div class="chat-text-ellipsis text-muted f-s-12" id="s_color"><span id="status"></span></div>
  </div>
  <div class="modal fade" id="exampleModalScrollable" aria-hidden="true" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalToggleLabel3">New Chat</h5>
          <button type="button" class="btn-close m-0 fs-5" data-bs-dismiss="modal"
            aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <label for="user_number" class="mb-1">Whatsapp Number</label>
        <input type="text" id="user_number" class="form-control b-r-6" placeholder="Whatsapp number" value="91">
        <label for="template_name" class="mb-1">Select Template</label>
        <select class="form-select" id="template_name">
            <option value="welcome">Welcome Message</option>
        </select>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light-primary" onclick="send_template()">Send</button>
          <button type="button" class="btn btn-light-secondary"
            data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
  <button type="button" id="save_btn" class="btn btn-light-success h-45 w-45 icon-btn b-r-22 me-sm-2" data-bs-toggle="modal"
                                data-bs-target="#exampleModalScrollables">
    <i class="ti ti-file-database f-s-20"></i>
  </button>
  <div class="modal fade" id="exampleModalScrollables" aria-hidden="true" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalToggleLabel3">Save Number</h5>
          <button type="button" class="btn-close m-0 fs-5" data-bs-dismiss="modal"
            aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <label for="save_number" class="mb-1">Whatsapp Number</label>
        <input type="text" id="save_number" class="form-control b-r-6" placeholder="Whatsapp number">
        <label for="save_name" class="mb-1">Name</label>
        <input type="text" id="save_name" class="form-control b-r-6" placeholder="Enter Name">
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light-primary" onclick="save_contact()">Save</button>
          <button type="button" class="btn btn-light-secondary"
            data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
  
    <div class="modal fade" id="imageStorage" aria-hidden="true" tabindex="-1">
    <div class="modal-dialog maxw-80 modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalToggleLabel3">Images</h5>
          <button type="button" class="btn-close m-0 fs-5" data-bs-dismiss="modal"
            aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div class="col-md-12">
                <div class="row" id="images_tab">
                    
                </div>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light-primary" onclick="images_send()">Send</button>
          <input type="file" id="image_files" style="display:none;" name="images[]" multiple accept=".png, .jpg, .jpeg">
          <label type="button" class="btn btn-light-primary" for="image_files">Choose File</label>
          <button type="button" class="btn btn-light-primary" id="imageUpload">Upload</button>
          <!--<button type="button" class="btn btn-light-secondary"-->
          <!--  data-bs-dismiss="modal">Close</button>-->
        </div>
      </div>
    </div>
  </div>
  
      <div class="modal fade" id="docsStorage" aria-hidden="true" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalToggleLabel3">Images</h5>
          <button type="button" class="btn-close m-0 fs-5" data-bs-dismiss="modal"
            aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div class="col-md-12">
                <div id="docs_tab">
                    
                </div>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light-primary" onclick="docs_send()">Send</button>
          <input type="file" id="doc_files" style="display:none;" name="docs[]" multiple accept=".pdf, .doc, .docx">
          <label type="button" class="btn btn-light-primary" for="doc_files">Choose File</label>
          <button type="button" class="btn btn-light-primary" id="docUpload">Upload</button>
        </div>
      </div>
    </div>
  </div>
</div>
                    </div>
                    <div class="card-body">
                        <div class="chat-container">
                          <!--<div class="text-center">-->
                          <!--  <span class="badge text-light-secondary">Today</span>-->
                          <!--</div>-->
                          <div id="live_chat_user">
                                    
                          </div>
    
                        </div>
                    </div>
                    <div class="card-footer">
                     <div class="chat-footer d-flex">
                      <div class="flex-grow-1">
                        <div class="input-group">
                        <div class="btn-group dropup  dropdown-icon-none">
                                <button class="btn btn-sm ms-2 me-2 b-r-4 btn-primary dropdown-toggle active" type="button"
                                  data-bs-toggle="dropdown" data-bs-auto-close="true" aria-expanded="false">
                                  <h4 class="text-white"><b>T</b></h4>
                                </button>
                                <ul class="dropdown-menu" data-popper-placement="bottom-start">
                                 <?php
    						      $sql = "SELECT * FROM `templates` WHERE `status` = '01' AND `client` = '$client_no'";
    						      $res = mysqli_query($con,$sql);
    						      while($row = mysqli_fetch_assoc($res)){
    						          $t_name = $row['t_name'];
        						          echo '<li class="p-2 chat_tab px-3" onclick="send_template_message(\''.$t_name.'\')"><i class="ti ti-brand-hipchat"></i> <span
                                            class="f-s-13">'.$row['d_name'].'</span>
                                            </li>';
    						      }
    						      ?>
                                </ul>
                        </div>
                          <input type="text" id="new_message" class="form-control b-r-6" placeholder="Type a message"
                            aria-label="Recipients username">
                          <button class="btn btn-sm btn-primary ms-2 me-2 b-r-4" onclick="perform()" type="button"><i
                              class="ti ti-send"></i> <span>Send</span> </button>
                          <button class="btn btn-sm btn-primary ms-2 me-2 b-r-4"  data-bs-toggle="modal"
                                data-bs-target="#imageStorage" type="button"><i
                              class="ti ti-photo"></i></button>
                          <button class="btn btn-sm btn-primary ms-2 me-2 b-r-4"  data-bs-toggle="modal"
                                data-bs-target="#docsStorage" type="button"><i
                              class="ti ti-files"></i></button>
                        </div>
                      </div>
                    </div>
                    </div>
                </div>
              </div>
            </div>
          </div>
        </main>
        <!-- Body main section ends -->

        <!-- tap on top -->
        <div class="go-top">
          <span class="progress-value">
            <i class="ti ti-arrow-up"></i>
          </span>
        </div>

        <!-- Footer Section starts-->
        <?php include('include/footer.php'); ?>
        <!-- Footer Section ends-->

      </div>
    </div>
  </div>
  <!-- essential   -->


  <!--customizer-->
  <div id="customizer"></div>

  <!-- latest jquery-->
  <script src="assets/js/jquery-3.6.3.min.js"></script>

  <!-- Simple bar js-->
  <script src="assets/vendor/simplebar/simplebar.js"></script>

  <!-- js -->
  <script src="assets/js/animation.js"></script>
  <script src="assets/js/chat.js"></script>

  <!-- Bootstrap js-->
  <script src="assets/vendor/bootstrap/bootstrap.bundle.min.js"></script>

  <!-- App js-->
  <script src="assets/js/script.js"></script>

  <!-- Customizer js-->
  <script src="assets/js/customizer.js"></script>
  
  <script src="assets/toasty_elements/toasty.js"></script>
<script>
    chat_user();
    var chatUserInterval = setInterval(chat_user, 1000);
    
    function chat_user(){
        var chat_user = 'chat_user';
        var query = $('#search_number').val();
        if(query === ''){
            $('#chat_user').show();
        }
          jQuery.ajax({
          type:'POST',
          url:'chat_user.php',
          data:{
              chat_user : chat_user,
              client_no : <?= $client_no ?>
          },
          success:function(result){
            $('#chat_user').html(result);
        }
        }) 
      }
      
      function search_numbers(){
        var chat_user = 'chat_user';
        var query = $('#search_number').val();
          jQuery.ajax({
          type:'POST',
          url:'search_user.php',
          data:{
              chat_user : chat_user,
              client_no : <?= $client_no ?>,
              query : query
          },
          success:function(result){
            $('#chat_user').hide();
            $('#search_user').html(result);
        }
        }) 
      }
      
      
      
      
      function view_chat(phone){
          var phone = phone;
          $('#chat_phone').val(phone);
          $('#save_number').val(phone);
          live_chat_user();
          function live_chat_user(){
              
            var phone = $('#chat_phone').val();
            jQuery.ajax({
              type:'POST',
              url:'user_status.php',
              data:{
                  phone : phone,
                  client_no : <?= $client_no ?>,
              },
              success:function(result){
                values = result.split("|");
                
                $('#status').html(values[1]);
                var a = '#s_display';
                var b = a.concat(phone);
                $('#s_phone').html($(b).val());
                let str = $(b).val();
                let str1 = str.replace(/\s+/g, '');
                let isLettersOnly = /^[a-zA-Z]+$/.test(str1);
                if(isLettersOnly){
                    $('#save_btn').hide();
                }
                else{
                    $('#save_btn').show();
                }
                if(values[1] == 'Online'){
                    $('#s_color').removeClass('text-secondary');
                    $('#s_color').addClass(values[2]);
                    $('#dot').removeClass('bg-secondary');
                    $('#dot').addClass(values[0]);
                }
                else{
                    $('#s_color').removeClass('text-success');
                    $('#s_color').addClass(values[2]);
                    $('#dot').removeClass('bg-success');
                    $('#dot').addClass(values[0]);
                }
                
             
                console.log(result);
            }
            })
            console.log(phone);
              jQuery.ajax({
              type:'POST',
              url:'single_chat.php',
              data:{
                  phone : phone,
                  client_no : <?= $client_no ?>,
              },
              success:function(result){ 
                $('#live_chat_user').html(result);
            }
            })
          }
          setInterval(live_chat_user,500);
      }
      
    function perform(){
        var number = $('#chat_phone').val();
        var message = $('#new_message').val();
        if(number != "" && message != ""){
            $.ajax({
                url: "actions/send_message/single_concept.php",
                type: "POST",
                data: {
                    number : number,
                    message : message
                },
                datatype:'html',
                success: function(response){
                    $('#new_message').val('');
                },
                error: function(){
                }
            });
        }
        else{
            toasty.error("Please select contact");
        }
    }
    function save_contact(){
        
        var save_number = $('#save_number').val();
        var save_name = $('#save_name').val();

          jQuery.ajax({
          type:'POST',
          url:'actions/save_number.php',
          data:{
              save_number : save_number,
              save_name : save_name
          },
          success:function(result){
              $('#exampleModalScrollables').modal('hide');
        }
        }) 
      }
    
     function send_template(){
        var user_number = $('#user_number').val();
        var template = $('#template_name').val();
        if(user_number != "" && template != ""){
            $.ajax({
                url: "actions/send_message/template_concept.php",
                type: "POST",
                data: {
                    number : user_number,
                    template : template
                },
                datatype:'html',
                success: function(response){
                    $('#exampleModalScrollable').modal('hide');
                },
                error: function(){
                }
            });
        }
        else{
            toasty.error("Please enter number");
        }
    }
    
    function send_template_message(template){
        var number = $('#chat_phone').val();
        if(number != "" && template != ""){
            $.ajax({
                url: "actions/send_message/template_concept.php",
                type: "POST",
                data: {
                    number : number,
                    template : template
                },
                datatype:'html',
                success: function(response){
                },
                error: function(){
                }
            });
        }
        else{
            toasty.error("Please select contact");
        }
    }
    
    document.addEventListener('keydown', function(event) {
        if (event.key === 'Enter') {
           var number = $('#chat_phone').val();
            var message = $('#new_message').val();
            if(number != "" && message != ""){
                $.ajax({
                    url: "actions/send_message/single_concept.php",
                    type: "POST",
                    data: {
                        number : number,
                        message : message
                    },
                    datatype:'html',
                    success: function(response){
                        $('#new_message').val('');
                    },
                    error: function(){
                    }
                });
            }
            else{
                toasty.error("Please select contact");
            }
        }
    });
    
$("#imageUpload").on("click", function(){
    const files = $("#image_files")[0].files;
    if (files.length > 0) {
        $('#imageUpload').html('<img width="20" height="20" src="assets/images/icons/load.gif">');
        const formData = new FormData();
        
        // Loop through each selected file and append it to the FormData object
        for (let i = 0; i < files.length; i++) {
            formData.append("images[]", files[i]);
        }
        
        $.ajax({
            url: "actions/multi_images_upload.php",  
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response){
                var res = response;
                var data = JSON.parse(res); 
                
                let htmlContent = '';
                data.forEach(function(image){
                    $("#uploadStatus").html('Upload successful!');
                });
                $('#imageUpload').html('Upload');
                fetch_images();
            },
            error: function(){
                $("#uploadStatus").html("An error occurred while uploading the images.");
                $('#imageUpload').html('Upload');
            }
        });
    } else {
        $("#uploadStatus").html("Please select images first.");
    }
});

$("#docUpload").on("click", function(){
    const files = $("#doc_files")[0].files;
    if (files.length > 0) {
        $('#docUpload').html('<img width="20" height="20" src="assets/images/icons/load.gif">');
        const formData = new FormData();
        
        for (let i = 0; i < files.length; i++) {
            formData.append("docs[]", files[i]);
        }
        
        $.ajax({
            url: "actions/multi_doc_upload.php",  
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response){
                var res = response;
                var data = JSON.parse(res); 
                
                let htmlContent = '';
                data.forEach(function(doc){
                    $("#docuploadStatus").html('Upload successful!');
                });
                $('#docUpload').html('Upload');
                fetch_docs();
            },
            error: function(){
                $("#docuploadStatus").html("An error occurred while uploading the docs.");
                $('#docUpload').html('Upload');
            }
        });
    } else {
        $("#uploadStatus").html("Please select images first.");
    }
});


fetch_images();
function fetch_images() {
    $.ajax({
        url: "actions/images_fetch.php",  // PHP script to fetch data
        type: "GET",           // Use GET request to fetch data
        success: function(response) {
            // Update the div with the fetched data
            $("#images_tab").html(response);
        },
        error: function() {
            // Handle errors
            $("#images_tab").html("An error occurred while fetching the data.");
        }
    });
}

fetch_docs();
function fetch_docs() {
    $.ajax({
        url: "actions/docs_fetch.php",  // PHP script to fetch data
        type: "GET",           // Use GET request to fetch data
        success: function(response) {
            // Update the div with the fetched data
            $("#docs_tab").html(response);
        },
        error: function() {
            // Handle errors
            $("#docs_tab").html("An error occurred while fetching the data.");
        }
    });
}

function images_send(){
        var number = $('#chat_phone').val();
        let files = [];
        const checkboxes = document.querySelectorAll(".img_checkbox");
        
        checkboxes.forEach(function(checkbox) {
            if (checkbox.checked) {  
                files.push(checkbox.value);
            }
        });
    
        if(number != "" && files != ""){
            console.log(files);
            $.ajax({
                url: "actions/send_message/file_concept.php",
                type: "POST",
                data: {
                    number : number,
                    files : files,
                    type : 'image'
                },
                datatype:'html',
                success: function(response){
                    $('#imageStorage').modal('hide');
                },
                error: function(){
                }
            });
        }
        else{
        }
    }
    
    function docs_send(){
        var number = $('#chat_phone').val();
        let files = [];
        const checkboxes = document.querySelectorAll(".docs_checkbox");
        
        checkboxes.forEach(function(checkbox) {
            if (checkbox.checked) {  
                files.push(checkbox.value);
            }
        });
    
        if(number != "" && files != ""){
            console.log(files);
            $.ajax({
                url: "actions/send_message/file_concept.php",
                type: "POST",
                data: {
                    number : number,
                    files : files,
                    type : 'document'
                },
                datatype:'html',
                success: function(response){
                    $('#docsStorage').modal('hide');
                },
                error: function(){
                }
            });
        }
        else{
        }
    }

</script>
</body>

</html>