<?php
include('actions/session.php');
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="Bulk Messaging - Whatsapp Admin">
  <meta name="title" content="Bulk Messaging - Whatsapp Admin">
  <meta name="author" content="Three Baboons Technologies">
  <link rel="icon" href="assets/images/logo/icon.png" type="image/x-icon">
  <link rel="shortcut icon" href="assets/images/logo/icon.png" type="image/x-icon">
  <title>Bulk Messaging - Whatsapp Admin </title>
  <!--font-awesome-css-->
  <link rel="stylesheet" href="assets/vendor/fontawesome/css/all.css">
  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600;700;800;900&display=swap"
    rel="stylesheet">

  <!-- prism css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/prism/prism.min.css">

  <!-- Animation css -->
  <link rel="stylesheet" href="assets/vendor/animation/animate.min.css">

  <!-- tabler icons-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/tabler-icons/tabler-icons.css">

  <!--flag Icon css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/flag-icons-master/flag-icon.css">
  
  <link rel="stylesheet" type="text/css" href="assets/vendor/toastify/toastify.css">
  <!-- apexcharts css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/apexcharts/apexcharts.css">

  <!-- simplebar css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/simplebar/simplebar.css">

  <!-- slick css -->
  <link rel="stylesheet" href="assets/vendor/slick/slick.css">
  <link rel="stylesheet" href="assets/vendor/slick/slick-theme.css">

  <!-- Data Table css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/datatable/jquery.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="assets/vendor/datatable/datatable2/buttons.dataTables.min.css">

  <!-- pignose-Calendar css -->
  <link rel="stylesheet" href="assets/vendor/pignose-Calendar/pignose.calendar.min.css">

  <!-- Bootstrap css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/bootstrap/bootstrap.min.css">

  <!-- App css-->
  <link rel="stylesheet" type="text/css" href="assets/css/style.css">

  <!-- Responsive css-->
  <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
  <link rel="stylesheet" type="text/css" href="assets/toasty_elements/toasty.css">
  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
</head>

<body>
  <div class="app-wrapper">
      <ul class="notifications"></ul>
    <div class="loader-wrapper">
       <div class="app-loader">
          <div class="loader-22">
          </div>
      </div>
    </div>

     <!-- Menu Navigation starts -->
     <?php include('include/navbar.php'); ?>
    <!-- Menu Navigation ends -->


    <div class="app-content">
      <div class="">
        <!-- Header Section starts -->
        <?php include('include/header.php'); ?>
        <!-- Header Section ends -->

        <!-- Body main section starts -->

        <!-- file-modal start -->
        <div class="file-modal">
          <div class="modal fade" id="file-modals" tabindex="-1" aria-labelledby="file-modals" aria-hidden="true">
            <div class="modal-dialog app_modal_md">
              <div class="modal-content">
                <div class="modal-header bg-primary-800">
                  <h1 class="modal-title fs-5 text-white" id="file-modal">Create Folder</h1>
                  <button type="button" class="fs-5 border-0  bg-none text-white" data-bs-dismiss="modal"
                    aria-label="Close"><i class="fa-solid fa-xmark fs-3"></i></button>
                </div>
                <div class="modal-body">
                  <div class="row">
                    <div class="mb-4">
                      <label for="file-foldername-input" class="form-label">Folder Name</label>
                      <input type="text" class="form-control" id="file-foldername-input" required=""
                        placeholder="Enter folder name">
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">Close</button>
                  <button type="button" class="btn btn-light-primary">Save changes</button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- file-modal end -->
        <main>
          <div class="container-fluid">
            <div class="row project_dashboard">
              <div class="col-12">
                <div class="card">
                  <div class="card-header d-flex flex-column gap-2">
                    <h5>Custom Styles</h5>
                  </div>
                  <div class="card-body">
                    <form class="row g-3 needs-validation" novalidate>
                      <div class="col-md-6">
    					<div class="mb-3">
        					<label for="input_file" class="form-label">Select Excel File</label>
        					  <input type="file" class="form-control" id="input_file">
    					</div>
    					<div class="input-group mb-3">
    					  <input type="text" class="form-control" id="input_phone">
    					  <button type="button" class="btn btn-primary" onclick="fromInput()">Add Phone</button>
    					</div>
    					<div class="phone_div" id="phone_div">
    					  <div class="mt-2 mb-2 d-flex justify-content-between">
    						  <h4>Phone Numbers</h4>
						      <button type="button" onclick="removeDuplicates()" class="btn btn-outline-primary">Remove Duplicates</button>
						  </div>
    						<textarea id="phone_numbers" rows="9" class="form-control"></textarea>
    					</div>
				    </div>
				     <div class="col-md-6">
						<div class="mb-3 d-flex justify-content-between">
							<div>
								<input type="radio" name="whatsapp_temp" id="message_type" onclick="change_type('Message')" value="Message" checked>
						  		<label for="message_type" class="form-label">Message</label>
							</div>
				
							<div>
								<input type="radio" name="whatsapp_temp" id="template_type" onclick="change_type('Template')" value="Template">
						  		<label for="template_type" class="form-label">Template</label>
							</div>
							<div>
								<input type="radio" name="whatsapp_temp" id="feedback_type" onclick="change_type('Feedback')" value="Feedback">
						  <label for="feedback_type" class="form-label">Feedback</label>
							</div>
							<input type="hidden" id="msg_type">
						</div>
						<div class="mb-3" id="img_temp0">
						  <label for="template_name" class="form-label">Template Name</label>
						  <select id="template_name" class="form-select">
						      <option value=""></option>
						      <?php
						      $sql = "SELECT * FROM `templates` WHERE `status` LIKE '%0%' AND `client` = '$client_no'";
						      $res = mysqli_query($con,$sql);
						      while($row = mysqli_fetch_assoc($res)){
						          echo '<option value="'.$row['t_name'].'">'.$row['d_name'].'</option>';
						      }
						      ?>
						  </select>
						</div>
						<div class="mb-3" id="msg_temp0">
						  <label for="message" class="form-label">Message</label>
						  <textarea class="form-control" id="message" placeholder="Message Content" rows="5"></textarea>
						  <div class="mt-2 d-flex">
						      <button type="button" onclick="boldText()" class="btn btn-outline-primary"><b>B</b></button>
						  </div>
						</div>
						<div class="mb-3" id="img_temp1">
        					<label for="image-file" class="form-label">Choose Image</label>
        					<div class="input-group">
        					<input type="file" accept="image/png, image/jpeg" class="form-control" id="image_file">
        					<button type="button" class="btn btn-primary" id="imageUpload">Upload</button>
        					</div>
        					<div id="uploadStatus"></div>
    					</div>
						<div class="mb-3" id="img_temp2">
						  <label for="image_url" class="form-label">Image Url</label>
						  <input type="text" class="form-control"  id="image_url" placeholder="https://tbteck.in/one.jpg">
						</div>
                      <div class="col-12">
                        <button class="btn btn-primary" id="sendBtn" onclick="perform()" type="button">Submit form</button>
                        <div id="sendStatus"></div>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </main>
      </div>
    </div>
    <!-- Body main section ends -->


    <!-- tap on top -->
    <div class="go-top">
      <span class="progress-value">
        <i class="ti ti-arrow-up"></i>
      </span>
    </div>


    <!-- Footer Section starts-->
    <?php include('include/footer.php'); ?>
    <!-- Footer Section ends-->
  </div>
  <!-- essential   -->
  <!--customizer-->
  <div id="customizer"></div>
  <!-- latest jquery-->
  <script src="assets/js/jquery-3.6.3.min.js"></script>

  <!-- Simple bar js-->
  <script src="assets/vendor/simplebar/simplebar.js"></script>

  <!--js-->
  <script src="assets/js/formvalidation.js"></script>
  
  <script src="assets/vendor/notifications/toastify-js.js"></script>
  <script src="assets/vendor/toastify/toastify.js"></script>

  <!-- Bootstrap js-->
  <script src="assets/vendor/bootstrap/bootstrap.bundle.min.js"></script>

  <!-- App js-->
  <script src="assets/js/script.js"></script>

  <!-- Customizer js-->
  <script src="assets/js/customizer.js"></script>
      <script src="assets/toasty_elements/toasty.js"></script>
<script type="text/javascript">

$('#input_file').on('change', function(event) {
    handleFile(event);
});

function handleFile(event) {
    const file = event.target.files[0];
    const reader = new FileReader();
    reader.onload = function(e) {
        const data = new Uint8Array(e.target.result);
        const workbook = XLSX.read(data, { type: 'array' });
        const firstSheetName = workbook.SheetNames[0];
        const worksheet = workbook.Sheets[firstSheetName];
        const jsonData = XLSX.utils.sheet_to_json(worksheet);
        console.log(jsonData);
        jsonData.forEach(datas => {
        		validatePhone(JSON.stringify(datas.phone));
        });
        $('#input_file').val('');
    };
    reader.readAsArrayBuffer(file);
}

function fromInput(){
	var phone = $('#input_phone').val();
	validatePhone(phone);
}

function validatePhone(phone){
	var phone = phone;
    var phoneNum = /^([6-9]{1})([0-9]{9})$/;

	if(phoneNum.test(phone) && phone != ""){
	    addPhoneField(phone);
	}
	else{
		toasty.error("Please enter valid number");
	}
}

function addPhoneField(currentPhone) {
	var phone_area = $('#phone_numbers');

	phone_area.append(currentPhone+'\n')

	$('#input_phone').val('');
}

</script>
<script>
change_type('Message');
function change_type(type){
    console.log(type);
    if(type == 'Message'){
        $('#msg_temp0').show();
        $('#img_temp0').hide();
        $('#img_temp1').hide();
        $('#img_temp2').hide();
        
        $('#msg_type').val('Message');
    }
    if(type == 'Template'){
        $('#msg_temp0').hide();
        $('#img_temp0').show();
        $('#img_temp1').show();
        $('#img_temp2').show();
        
        $('#msg_type').val('Template');
    }
}

// Remove duplicates
function removeDuplicates() {
    const textarea = document.getElementById('phone_numbers');
    const lines = textarea.value.split('\n');  // Split the textarea content into lines
    const uniqueLines = [...new Set(lines)];  // Use a Set to remove duplicates

    textarea.value = uniqueLines.join('\n');  // Join the unique lines back into a string
}

// Bold Concept
function boldText() {
    const textarea = document.getElementById('message');
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;

    if (start !== end) {
        const selectedText = textarea.value.substring(start, end);
        const beforeText = textarea.value.substring(0, start);
        const afterText = textarea.value.substring(end);

        const beforeString = "*";  // String to add before the selected text
        const afterString = "*";   // String to add after the selected text

        textarea.value = beforeText + beforeString + selectedText + afterString + afterText;

        // Optionally, re-select the modified text
        textarea.setSelectionRange(start, end + beforeString.length + afterString.length);
    }
    else{
            Toastify({
          text: "Please select the text you want to bold!",
          duration: 3000,
          position: "right",
          close : true,
          style: {
            background: "rgb(var(--danger),1)",
          }
        }).showToast();
    }
}


$("#imageUpload").on("click", function(){
    const file = $("#image_file")[0].files[0];
    if (file) {
        $('#imageUpload').html('<img width="20" height="20" src="assets/images/icons/load.gif">');
        const formData = new FormData();
        formData.append("image", file);
        $.ajax({
            url: "actions/images_upload.php",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response){
                var res = response;
                var data = res.split(':');
                $("#uploadStatus").html(data[0]);
                $("#image_url").val('https://tbteck.in/Demo/admin/images_upload/'+data[1]);
                $('#imageUpload').html('Upload');
            },
            error: function(){
                $("#uploadStatus").html("An error occurred while uploading the image.");
                $('#imageUpload').html('Upload');
            }
        });
    } else {
        $("#uploadStatus").html("Please select an image first.");
    }
});

function perform(){
    // Phone number array
    var data = $('#phone_numbers').val();
    var res = data.split(/\s+/);
    const filteredArray = res.filter(word => word.trim() !== '');
    console.log(filteredArray);
    var message = $('#message').val();
    var msg_type = $('#msg_type').val();
    var template = $('#template_name').val();
    var link = $('#image_url').val();
    
    if(data != ""){
        $('#sendBtn').html('<img width="20" height="20" src="assets/images/icons/load.gif">');
        filteredArray.forEach(function(numbers,index){
           $.ajax({
            url: "actions/send_message/bulk_concept.php",
            type: "POST",
            data: {
                numbers : numbers,
                message : message,
                template : template,
                link : link,
                msg_type : msg_type
            },
            datatype:'html',
            success: function(response){
                console.log(response);
                    // $("#sendStatus").html(response);
                    toasty.success(response);
            },
            error: function(){
                $("#sendStatus").html("An error occurred");
            }
        });
        $('#sendBtn').html('Submit');
        });
    }
    else{
         Toastify({
          text: "Please fill the form!",
          duration: 3000,
          position: "right",
          close : true,
          style: {
            background: "rgb(var(--danger),1)",
          }
        }).showToast();
    }
}
</script>
</body>

</html>