<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="Register - Whatsapp Admin">
  <meta name="title" content="Register - Whatsapp Admin">
  <meta name="author" content="Three Baboons Technologies">
  <link rel="icon" href="assets/images/logo/icon.png" type="image/x-icon">
  <link rel="shortcut icon" href="assets/images/logo/icon.png" type="image/x-icon">
  <title>Register - Whatsapp Admin </title>

  <!--font-awesome-css-->
  <link rel="stylesheet" href="assets/vendor/fontawesome/css/all.css">

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600;700;800;900&display=swap"
    rel="stylesheet">

  <!-- tabler icons-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/tabler-icons/tabler-icons.css">

  <!-- Bootstrap css-->
  <link rel="stylesheet" type="text/css" href="assets/vendor/bootstrap/bootstrap.min.css">

  <!-- App css-->
  <link rel="stylesheet" type="text/css" href="assets/css/style.css">

  <!-- Responsive css-->
  <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
    <style>
         #signup_status{
            display:none;
        }
        #timer{
            font-size:13px;
        }
        #otp_status{
            font-size: 7px;
            margin:auto;
        }
        .error_text{
            font-size: 10px !important;
            margin-top: 0px;
            color: red !important;
        }
        .red_color{
            color:red !important;
        }
        .green_color{
            color:green !important;
        }
        .font-13{
            font-size:13px;
        }
        .red_border{
            border:1px solid red;
        }
        .error{
            font-size: 10px;
            margin-top: 0px;
            color: red;
        }
    </style>
</head>

<body>
  <div class="app-wrapper d-block">
    <div class="">
      <!-- Body main section starts -->
      <main class="w-100">
        <!-- sign up start -->
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-7 col-xl-8 d-none d-lg-block p-0">
              <div class="image-contentbox">
                <img src="assets/images/login/05.png" class="img-fluid" alt="">
              </div>
            </div>
            <div class="col-lg-5 col-xl-4 p-0 bg-white">
              <div class="form-container">
                <form class="app-form" id="sign_form">
                  <div class="row">
                    <div class="col-12">
                      <div class="mb-5 text-center text-lg-start">
                        <h2 class="text-primary f-w-600">Create Account</h2>
                        <p>Get Start Today!</p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="mb-3">
                        <label for="fname" class="form-label">First Name</label>
                        <input type="text" name="fname" class="form-control" placeholder="First Name" id="fname"
                          required>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="mb-3">
                        <label for="lname" class="form-label">Last Name</label>
                        <input type="text" name="lname" class="form-control" placeholder="Last Name" id="lname"
                          required>
                      </div>
                    </div>
                    <div class="d-flex">
                    <div class="col-8">
                      <div class="mb-3">
                        <label for="phone" class="form-label">Phone Number</label>
                        <input type="text" name="phone" class="form-control" placeholder="Phone Number" id="phone" required>
                        <p class="error_text">Enter valid Phone Number.</p>
                      </div>
                    </div>
                    <div class="col-4 align-items-center mx-2 d-flex flex-row justify-content-between mts-4 mb-0 mt-3">
                        <a href="javascript:;" id="otp_btn" onclick="otpopen()"></a>
                        <p id="timer" class="mb-0 mt-1"></p>
                    </div>
                    </div>
                    <div class="col-12 otp_form">
                        <div class="mb-3">
                           <label class="form-label" for="otp">OTP</label>
                          <input class="form-control" id="otp" type="text" name="otp" placeholder="Otp" required>
                        </div>
                    </div>
                    <div class="col-12">
                      <div class="mb-3">
                        <label for="username" class="form-label">Email</label>
                        <input type="email" class="form-control" placeholder="Email" id="email" name="email" required>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="mb-3">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" name="password" class="form-control" placeholder="Enter Your Password" id="password"
                          required>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="mb-3">
                        <label for="password" class="form-label">Confirm Password</label>
                        <input type="password" name="con_password" class="form-control" placeholder="Enter Your Password" id="con_password"
                          required>
                      </div>
                    </div>
                    <div class="col-md-12">
                              <p id="signup_status" class="text-center mt-3"></p>
                          </div>
                    <div class="col-12">
                      <div class="mb-3">
                        <button class="btn btn-primary w-100" type="submmit" id="submit" name="submit">Sign Up</button>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="text-center text-lg-start">
                        Already Have A Account? <a href="login.php" class="link-primary text-decoration-underline">
                          Sign in</a>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
        <!-- sign up end -->
      </main>
      <!-- Body main section ends -->
    </div>
  </div>

  <!-- essential   -->

  <!-- latest jquery-->
  <script src="assets/js/jquery-3.6.3.min.js"></script>

  <script src="assets/js/jquery.validate.min.js"></script>
  <!-- Bootstrap js-->
  <script src="assets/vendor/bootstrap/bootstrap.bundle.min.js"></script>
  
  <script>
  $(document).ready(function(){
      $('.otp_form').hide(); 
      $('#timer').hide();
      $('#otp_btn').html('Send Otp');
      $('.error_text').hide();
    });
      function otpopen(){
        var phone = $('#phone').val();
        if(phone != ""){
            var expr = /^(0|91)?[6-9][0-9]{9}$/;
            if (expr.test(phone)) {
                $('.error_text').hide();
                jQuery.ajax({
                type:'POST',
                url:'actions/send_otp.php',
                data:"phone="+phone,
                success:function(result){
                    if(result == "Otp sent successfully"){
                        $('.otp_form').show();
                        $('#timer').show();
                        $('#otp_btn').hide();
                        $('#otp_status').html(result);
                        $('#otp_status').removeClass('red').addClass('green');
                      var countDownDate = new Date().getTime()+2*60000;
                      var x = setInterval(function() {
                      var now = new Date().getTime();
                      var distance = countDownDate - now;
                      var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                      var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                      var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                      var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                      $("#timer").html(minutes + " : " + seconds);
                      if (distance < 0) {
                        clearInterval(x);
                        $('#otp_btn').html('Resend Otp');
                        $('#otp_btn').show();
                        $('#timer').html('0:0');
                        $('#timer').hide();
                      }
                    }, 1000);
                    }
                    if(result == "Phone number already exist"){
                     $('#otp_status').html(result);
                     $('#otp_status').addClass('red');   
                    }
                    else{
                     $('#otp_status').html(result);
                     $('#otp_status').addClass('red');   
                    }
                 }
                });
            }
            else{
                $('.error_text').show();
            }
        }
        else{
          $('.error_text').show();
        }
    }
    
    $(document).ready(function(){
        $("#sign_form").validate({
            rules: {
                fname:"required",
                lname: "required",
                phone: "required",
                otp: "required",
                email: "required",
                password: {
                    required: true,
                    minlength: 5
                },
                con_password: {
                    required: true,
                    minlength: 5,
                    equalTo: "#password"
                }
            },
            messages: {
                fname: "Please enter your name",
                lname: "Please enter your name",
                phone: "Please enter your phone",
                otp: "Please enter your otp",
                email: "Please enter your email address",
                password: "Please enter your password",
                con_password: "Please enter valid password"
            },
            submitHandler: function (form) {
                console.log($(form).serialize());
                var otp = $('#otp').val();
                if(otp !=""){
                $.ajax({
                    type: "POST",
                    url: "actions/register_data.php",
                    data: $(form).serialize(),
                    success: function (result) {
                        console.log(result);
                     if(result == 'Sign up Successfull'){
                      location.replace('login.php');
                     }
                     if(result == 'Email already Exist!'){
                      $('#signup_status').html(result);
                      $('#signup_status').removeClass('green_color').addClass('red_color');
                      $('#signup_status').show(500);
                       var timer = setTimeout(function () {
                        $('#signup_status').hide(500);
                      }, 3000);
                     }
                     else{
                      $('#signup_status').html(result);
                      $('#signup_status').removeClass('green_color').addClass('red_color');
                      $('#signup_status').show(500);
                       var timer = setTimeout(function () {
                        $('#signup_status').hide(500);
                      }, 3000);
                     }
                    },
                    error: function (result) {
                       console.log(result);
                    }
                });
                }else{
                      $('#signup_status').html('Please verify otp');
                      $('#signup_status').removeClass('green_color').addClass('red_color');
                      $('#signup_status').show(500);
                       var timer = setTimeout(function () {
                        $('#signup_status').hide(500);
                      }, 3000);
                    return false;
                }
                return false;
            }
              });
        });
  </script>

</body>

</html>